<?php
session_start();
if (!isset($_SESSION['usuario']) || !$_SESSION['admin']) {
    header("Location: login.php");
    exit;
}
$db = new SQLite3(__DIR__ . '/../dados.db');
$id = $_GET['id'] ?? 0;
$stmt = $db->prepare("SELECT * FROM usuarios WHERE id = ?");
$stmt->bindValue(1, $id);
$result = $stmt->execute();
$usuario = $result->fetchArray(SQLITE3_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Editar Usuário</title>
  <link rel="stylesheet" href="../public/style.css">
</head>
<body>
  <div class="container">
    <h1>Editar Usuário</h1>
    <form action="../backend/salvar_usuario.php" method="POST">
      <input type="hidden" name="modo" value="editar">
      <input type="hidden" name="id" value="<?= $usuario['id'] ?>">
      <label>Usuário:
        <input type="text" name="usuario" value="<?= htmlspecialchars($usuario['usuario']) ?>" required>
      </label>
      <label>Senha (deixe em branco para manter a atual):
        <input type="password" name="senha">
      </label>
      <label>Administrador:
        <select name="admin" required>
          <option value="0" <?= $usuario['admin'] ? '' : 'selected' ?>>Não</option>
          <option value="1" <?= $usuario['admin'] ? 'selected' : '' ?>>Sim</option>
        </select>
      </label>
      <button type="submit">Salvar Alterações</button>
    </form>
    <br>
    <a href="gerenciar_usuarios.php">Voltar</a>
  </div>
</body>
</html>
