<?php
// Retorna as datas disponíveis com base na regra dos 30% de reserva para PcD
header('Content-Type: application/json');

$db = new SQLite3(__DIR__ . '/../dados.db');

// Buscar todas as datas e horários disponíveis
$datas = $db->query("SELECT data FROM datas");
$horarios = $db->query("SELECT hora FROM horarios");

$lista_datas = [];
while ($row = $datas->fetchArray(SQLITE3_ASSOC)) {
    $lista_datas[] = $row['data'];
}

$lista_horas = [];
while ($row = $horarios->fetchArray(SQLITE3_ASSOC)) {
    $lista_horas[] = $row['hora'];
}

$total_horarios = count($lista_horas);
$limite_normal = floor($total_horarios * 0.7);
$limite_pcd = $total_horarios - $limite_normal;

$resultado = [];

foreach ($lista_datas as $data) {
    $qtd_normal = $db->querySingle("SELECT COUNT(*) FROM agendamentos WHERE data_agenda = '$data' AND deficiencia = 'nao'");
    $qtd_pcd = $db->querySingle("SELECT COUNT(*) FROM agendamentos WHERE data_agenda = '$data' AND deficiencia = 'sim'");

    $disponivel_normal = $qtd_normal < $limite_normal;
    $disponivel_pcd = $qtd_pcd < $limite_pcd;

    $resultado[] = [
        'data' => $data,
        'disponivel_normal' => $disponivel_normal,
        'disponivel_pcd' => $disponivel_pcd
    ];
}

echo json_encode($resultado);
?>
