<?php
session_start();
if (!isset($_SESSION['usuario']) || !$_SESSION['admin']) {
    header("Location: login.php");
    exit;
}
$db = new SQLite3(__DIR__ . '/../dados.db');
$result = $db->query("SELECT * FROM usuarios ORDER BY usuario ASC");
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Gerenciar Usuários</title>
  <link rel="stylesheet" href="../public/style.css">
</head>
<body>
  <div class="container">
    <h1>Usuários do Sistema</h1>
    <table border="1" cellpadding="8" cellspacing="0">
      <tr><th>Usuário</th><th>Administrador</th><th>Ações</th></tr>
      <?php while ($row = $result->fetchArray(SQLITE3_ASSOC)): ?>
        <tr>
          <td><?= htmlspecialchars($row['usuario']) ?></td>
          <td><?= $row['admin'] ? 'Sim' : 'Não' ?></td>
          <td><a href="editar_usuario.php?id=<?= $row['id'] ?>">Editar</a></td>
        </tr>
      <?php endwhile; ?>
    </table>
    <br>
    <a href="cadastrar_usuario.php"><button>Cadastrar Novo Usuário</button></a>
    <br><br>
    <a href="inicial.php">Voltar</a>
  </div>
</body>
</html>
