<?php
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}
$db = new SQLite3(__DIR__ . '/../dados.db');
$db->exec("CREATE TABLE IF NOT EXISTS horarios (hora TEXT PRIMARY KEY)");
$result = $db->query("SELECT hora FROM horarios ORDER BY hora ASC");
$horas_existentes = [];
while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
    $horas_existentes[] = $row['hora'];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Horários Disponíveis</title>
  <link rel="stylesheet" href="../public/style.css">
</head>
<body>
<div class="container">
  <h1>Horários Disponíveis</h1>
  <form action="../backend/salvar_horarios.php" method="POST">
    <label>Digite os horários (um por linha):
      <textarea name="horarios" rows="10" required><?= implode("\n", $horas_existentes) ?></textarea>
    </label>
    <button type="submit">Salvar</button>
  </form>
  <br><a href="inicial.php">Voltar</a>
</div>
</body>
</html>
