<?php
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}
$db = new SQLite3(__DIR__ . '/../dados.db');
$result = $db->query("SELECT DISTINCT data_agenda FROM agendamentos ORDER BY data_agenda ASC");
$datas = [];
while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
    $datas[] = $row['data_agenda'];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Relatório Diário</title>
  <link rel="stylesheet" href="../public/style.css">
</head>
<body>
<div class="container">
  <h1>Relatório Diário de Agendamentos</h1>
  <form action="../backend/gerar_relatorio.php" method="GET">
    <label>Selecione a data:
      <select name="data" required>
        <?php foreach ($datas as $d): ?>
          <option value="<?= $d ?>"><?= $d ?></option>
        <?php endforeach; ?>
      </select>
    </label>
    <button type="submit">Exibir</button>
  </form>
  <br><a href="inicial.php">Voltar</a>
</div>
</body>
</html>
