<?php
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: ../admin/login.php");
    exit;
}
$data = $_GET['data'] ?? '';
$db = new SQLite3(__DIR__ . '/../dados.db');
$stmt = $db->prepare("SELECT * FROM agendamentos WHERE data_agenda = ? ORDER BY horario");
$stmt->bindValue(1, $data);
$result = $stmt->execute();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Relatório - <?= htmlspecialchars($data) ?></title>
  <link rel="stylesheet" href="../public/style.css">
</head>
<body>
<div class="container">
  <h1>Agendamentos de <?= htmlspecialchars($data) ?></h1>
  <table border="1" cellpadding="8">
    <tr><th>Nome</th><th>CPF</th><th>Horário</th><th>Deficiente</th></tr>
    <?php while ($row = $result->fetchArray(SQLITE3_ASSOC)): ?>
      <tr>
        <td><?= htmlspecialchars($row['nome']) ?></td>
        <td><?= htmlspecialchars($row['cpf']) ?></td>
        <td><?= htmlspecialchars($row['horario']) ?></td>
        <td><?= $row['deficiencia'] === 'sim' ? 'Sim' : 'Não' ?></td>
      </tr>
    <?php endwhile; ?>
  </table>
  <br><a href="../admin/relatorio_diario.php">Voltar</a>
</div>
</body>
</html>
