<?php
session_start();
if (!isset($_SESSION['usuario']) || !$_SESSION['admin']) {
    header("Location: ../admin/login.php");
    exit;
}
$db = new SQLite3(__DIR__ . '/../dados.db');
$modo = $_POST['modo'];
$usuario = $_POST['usuario'];
$admin = $_POST['admin'] === '1' ? 1 : 0;

if ($modo === 'novo') {
    $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT);
    $stmt = $db->prepare("INSERT INTO usuarios (usuario, senha, admin) VALUES (?, ?, ?)");
    $stmt->bindValue(1, $usuario);
    $stmt->bindValue(2, $senha);
    $stmt->bindValue(3, $admin);
    $stmt->execute();
} elseif ($modo === 'editar') {
    $id = $_POST['id'];
    if (!empty($_POST['senha'])) {
        $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT);
        $stmt = $db->prepare("UPDATE usuarios SET usuario = ?, senha = ?, admin = ? WHERE id = ?");
        $stmt->bindValue(1, $usuario);
        $stmt->bindValue(2, $senha);
        $stmt->bindValue(3, $admin);
        $stmt->bindValue(4, $id);
    } else {
        $stmt = $db->prepare("UPDATE usuarios SET usuario = ?, admin = ? WHERE id = ?");
        $stmt->bindValue(1, $usuario);
        $stmt->bindValue(2, $admin);
        $stmt->bindValue(3, $id);
    }
    $stmt->execute();
}
header("Location: ../admin/gerenciar_usuarios.php");
exit;
?>
