<?php
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}
$db = new SQLite3(__DIR__ . '/../dados.db');
$db->exec("CREATE TABLE IF NOT EXISTS datas (data TEXT PRIMARY KEY)");
$datas = $db->query("SELECT data FROM datas ORDER BY data ASC");
$datas_existentes = [];
while ($row = $datas->fetchArray(SQLITE3_ASSOC)) {
    $datas_existentes[] = $row['data'];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Datas Disponíveis</title>
  <link rel="stylesheet" href="../public/style.css">
</head>
<body>
<div class="container">
  <h1>Selecionar Datas Disponíveis</h1>
  <form action="../backend/salvar_data.php" method="POST">
    <label>Selecione datas futuras (até 30 dias):
      <input type="date" name="data[]" min="<?= date('Y-m-d') ?>" max="<?= date('Y-m-d', strtotime('+30 days')) ?>" multiple>
    </label>
    <button type="submit">Salvar</button>
  </form>
  <h3>Datas já cadastradas:</h3>
  <ul>
    <?php foreach ($datas_existentes as $data): ?>
      <li><?= $data ?></li>
    <?php endforeach; ?>
  </ul>
  <br><a href="inicial.php">Voltar</a>
</div>
</body>
</html>
