<?php
try {
    $db = new SQLite3(__DIR__ . '/../dados.db');
    $db->exec("CREATE TABLE IF NOT EXISTS usuarios (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        usuario TEXT UNIQUE NOT NULL,
        senha TEXT NOT NULL,
        admin INTEGER NOT NULL
    )");

    $usuario = 'admin';
    $senha_plana = '123456';
    $senha_hash = password_hash($senha_plana, PASSWORD_DEFAULT);
    $admin = 1;

    $stmt = $db->prepare("INSERT OR IGNORE INTO usuarios (usuario, senha, admin) VALUES (?, ?, ?)");
    $stmt->bindValue(1, $usuario);
    $stmt->bindValue(2, $senha_hash);
    $stmt->bindValue(3, $admin);
    $stmt->execute();

    echo "Usuário 'admin' criado com senha padrão '123456'.";
    $db->close();
} catch (Exception $e) {
    echo "Erro ao criar admin: " . $e->getMessage();
}
?>
